/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.api.domain;

import com.elitesland.cbpl.common.base.ResponseVO;
import java.util.Date;
import javax.annotation.Nullable;

public class HttpResult<T>
extends ResponseVO {
    @Nullable
    private String errorNo;
    @Nullable
    private T data;
    private boolean success;

    public boolean getSuccess() {
        return super.getCode() == 200;
    }

    public static <T> HttpResult<T> ok() {
        return HttpResult.ok(null);
    }

    public static <T> HttpResult<T> ok(T data) {
        HttpResult<T> result = HttpResult.result(200, "");
        result.setData(data);
        return result;
    }

    public static <T> HttpResult<T> error() {
        return HttpResult.error(null);
    }

    public static <T> HttpResult<T> error(String msg) {
        return HttpResult.error(null, msg);
    }

    public static <T> HttpResult<T> error(String errorNo, String msg) {
        HttpResult<T> result = HttpResult.result(500, msg);
        result.setErrorNo(errorNo);
        return result;
    }

    public static <T> HttpResult<T> badRequest() {
        return HttpResult.badRequest(null, "400: Bad Request.");
    }

    public static <T> HttpResult<T> badRequest(String msg) {
        return HttpResult.badRequest(null, msg);
    }

    public static <T> HttpResult<T> badRequest(String errorNo, String msg) {
        HttpResult<T> result = HttpResult.result(400, msg);
        result.setErrorNo(errorNo);
        return result;
    }

    public static <T> HttpResult<T> unauthorized() {
        return HttpResult.unauthorized(null, "401: Unauthorized.");
    }

    public static <T> HttpResult<T> unauthorized(String msg) {
        return HttpResult.unauthorized(null, msg);
    }

    public static <T> HttpResult<T> unauthorized(String errorNo, String msg) {
        HttpResult<T> result = HttpResult.result(401, msg);
        result.setErrorNo(errorNo);
        return result;
    }

    public static <T> HttpResult<T> notFound() {
        return HttpResult.notFound(null, "404: Not Found.");
    }

    public static <T> HttpResult<T> notFound(String msg) {
        return HttpResult.notFound(null, msg);
    }

    public static <T> HttpResult<T> notFound(String errorNo, String msg) {
        HttpResult<T> result = HttpResult.result(404, msg);
        result.setErrorNo(errorNo);
        return result;
    }

    public static <T> HttpResult<T> requestEntityTooLarge() {
        return HttpResult.requestEntityTooLarge(null, "413: Request Entity Too Large.");
    }

    public static <T> HttpResult<T> requestEntityTooLarge(String msg) {
        return HttpResult.requestEntityTooLarge(null, msg);
    }

    public static <T> HttpResult<T> requestEntityTooLarge(String errorNo, String msg) {
        HttpResult<T> result = HttpResult.result(413, msg);
        result.setErrorNo(errorNo);
        return result;
    }

    public static <T> HttpResult<T> internalServerError() {
        return HttpResult.internalServerError(null, "500: Internal Server Error.");
    }

    public static <T> HttpResult<T> internalServerError(String msg) {
        return HttpResult.internalServerError(null, msg);
    }

    public static <T> HttpResult<T> internalServerError(String errorNo, String msg) {
        HttpResult<T> result = HttpResult.result(500, msg);
        result.setErrorNo(errorNo);
        return result;
    }

    public static <T> HttpResult<T> notImplemented() {
        return HttpResult.notImplemented(null, "501: Not Implemented.");
    }

    public static <T> HttpResult<T> notImplemented(String msg) {
        return HttpResult.notImplemented(null, msg);
    }

    public static <T> HttpResult<T> notImplemented(String errorNo, String msg) {
        HttpResult<T> result = HttpResult.result(501, msg);
        result.setErrorNo(errorNo);
        return result;
    }

    public static <T> HttpResult<T> bagGateway() {
        return HttpResult.bagGateway(null, "502: Bad Gateway.");
    }

    public static <T> HttpResult<T> bagGateway(String msg) {
        return HttpResult.bagGateway(null, msg);
    }

    public static <T> HttpResult<T> bagGateway(String errorNo, String msg) {
        HttpResult<T> result = HttpResult.result(502, msg);
        result.setErrorNo(errorNo);
        return result;
    }

    public static <T> HttpResult<T> serviceUnavailable() {
        return HttpResult.serviceUnavailable(null, "503: Service Unavailable.");
    }

    public static <T> HttpResult<T> serviceUnavailable(String msg) {
        return HttpResult.serviceUnavailable(null, msg);
    }

    public static <T> HttpResult<T> serviceUnavailable(String errorNo, String msg) {
        HttpResult<T> result = HttpResult.result(503, msg);
        result.setErrorNo(errorNo);
        return result;
    }

    public static <T> HttpResult<T> gatewayTimeout() {
        return HttpResult.gatewayTimeout(null, "504: Gateway Timeout.");
    }

    public static <T> HttpResult<T> gatewayTimeout(String msg) {
        return HttpResult.gatewayTimeout(null, msg);
    }

    public static <T> HttpResult<T> gatewayTimeout(String errorNo, String msg) {
        HttpResult<T> result = HttpResult.result(504, msg);
        result.setErrorNo(errorNo);
        return result;
    }

    public static <T> HttpResult<T> result(int code, String msg) {
        return HttpResult.result(code, null, msg);
    }

    public static <T> HttpResult<T> result(int code, String errorNo, String msg) {
        HttpResult<T> result = new HttpResult<T>();
        result.setCode(code);
        result.setMsg(msg);
        result.setErrorNo(errorNo);
        result.setTime(new Date());
        return result;
    }

    @Nullable
    public String getErrorNo() {
        return this.errorNo;
    }

    @Nullable
    public T getData() {
        return this.data;
    }

    public void setErrorNo(@Nullable String errorNo) {
        this.errorNo = errorNo;
    }

    public void setData(@Nullable T data) {
        this.data = data;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResult)) {
            return false;
        }
        HttpResult other = (HttpResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSuccess() != other.getSuccess()) {
            return false;
        }
        String this$errorNo = this.getErrorNo();
        String other$errorNo = other.getErrorNo();
        if (this$errorNo == null ? other$errorNo != null : !this$errorNo.equals(other$errorNo)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.getSuccess() ? 79 : 97);
        String $errorNo = this.getErrorNo();
        result = result * 59 + ($errorNo == null ? 43 : $errorNo.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "HttpResult(errorNo=" + this.getErrorNo() + ", data=" + this.getData() + ", success=" + this.getSuccess() + ")";
    }
}

