/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.websocket.config;

import com.elitesland.cbpl.tool.websocket.config.WebSocketProperties;
import com.elitesland.cbpl.tool.websocket.handler.WebSocketAuthHandler;
import com.elitesland.cbpl.tool.websocket.interceptor.CustomWebSocketInterceptor;
import com.elitesland.cbpl.tool.websocket.notifier.WebSocketNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@EnableWebSocket
@Configuration
@EnableConfigurationProperties(value={WebSocketProperties.class})
@ConditionalOnProperty(prefix="cbpl.tool.ws", name={"enabled"}, havingValue="true")
public class WebSocketConfig
implements WebSocketConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketConfig.class);
    private final WebSocketProperties webSocketProperties;

    @Bean
    @ConditionalOnMissingBean
    public WebSocketNotifier webSocketPusher() {
        logger.info("[PHOENIX-WS] websocket message pusher");
        return new WebSocketNotifier();
    }

    @Bean
    public CustomWebSocketInterceptor customWebSocketInterceptor() {
        return new CustomWebSocketInterceptor();
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        logger.info("[PHOENIX-WS] websocket message handler: {}", (Object)this.webSocketProperties.getEntry());
        registry.addHandler((WebSocketHandler)new WebSocketAuthHandler(), new String[]{this.webSocketProperties.getEntry()}).setAllowedOrigins(this.webSocketProperties.getAllow()).withSockJS();
    }

    public WebSocketConfig(WebSocketProperties webSocketProperties) {
        this.webSocketProperties = webSocketProperties;
    }
}

