/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.websocket.handler;

import com.elitesland.cbpl.tool.websocket.handler.WsSessionManager;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class WebSocketAuthHandler
extends TextWebSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketAuthHandler.class);

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        logger.info("[PHOENIX-WS] websocket connection established: {} of u-{}", (Object)session.getId(), (Object)WsSessionManager.getUserId(session));
        WsSessionManager.add(session);
    }

    protected void handleTextMessage(@NonNull WebSocketSession session, @NonNull TextMessage message) throws Exception {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        logger.trace("[PHOENIX-WS] message from websocket client: {}", (Object)message);
    }

    public void afterConnectionClosed(WebSocketSession session, @NonNull CloseStatus status) throws Exception {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        logger.info("[PHOENIX-WS] afterConnectionClosed u-{}", (Object)WsSessionManager.getUserId(session));
        WsSessionManager.removeAndClose(session);
        logger.info("[PHOENIX-WS] websocket connection closed: {}", (Object)session.getId());
    }
}

