/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.websocket.handler;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.tool.websocket.util.WebSocketUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;

public class WsSessionManager {
    private static final Logger logger = LoggerFactory.getLogger(WsSessionManager.class);
    private static final ConcurrentHashMap<String, WebSocketSession> SESSION_POOL = new ConcurrentHashMap();
    private static final Map<String, String> SESSION_USER_IDS = new ConcurrentHashMap<String, String>();

    public static void add(WebSocketSession session) {
        String sessionId = session.getId();
        String userId = WsSessionManager.getUserId(session);
        String clientIp = WebSocketUtil.getAttrStr(session, "ip");
        SESSION_POOL.computeIfAbsent(sessionId, sid -> {
            SESSION_USER_IDS.compute(userId, (uid, sids) -> sids == null ? sessionId : sids + "," + sessionId);
            return session;
        });
    }

    public static void remove(WebSocketSession session) {
        String sessionId = session.getId();
        String userId = WebSocketUtil.getAttrStr(session, "userId");
        SESSION_USER_IDS.computeIfPresent(userId, (uid, sids) -> {
            String[] split = sids.split(",");
            ArrayList<String> sessionIds = new ArrayList<String>(Arrays.asList(split));
            for (String sid : split) {
                if (!sessionId.equals(sid)) continue;
                SESSION_POOL.remove(sid);
                sessionIds.remove(sid);
            }
            return StringUtils.join(sessionIds, (String)",");
        });
    }

    public static void removeAndClose(WebSocketSession session) {
        WsSessionManager.remove(session);
        try {
            session.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getUserId(WebSocketSession session) {
        return WebSocketUtil.getAttrStr(session, "userId");
    }

    public static List<String> push(Set<String> recipients, Consumer<WebSocketSession> consumer) {
        ArrayList<String> recipientsPushed = new ArrayList<String>();
        SESSION_USER_IDS.forEach((uid, sessionIds) -> {
            if (recipients.contains(uid)) {
                for (String sid : sessionIds.split(",")) {
                    if (!ObjectUtil.isNotNull((Object)SESSION_POOL.get(sid)) || !SESSION_POOL.get(sid).isOpen()) continue;
                    try {
                        consumer.accept(SESSION_POOL.get(sid));
                    }
                    catch (SockJsTransportFailureException e) {
                        logger.error("[PHOENIX-WS] {}-pushToClient failed.", (Object)sid);
                    }
                }
                recipientsPushed.add((String)uid);
            }
        });
        return recipientsPushed;
    }
}

