/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.websocket.interceptor;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.elitesland.cbpl.tool.core.http.HttpServletUtil;
import java.nio.charset.Charset;
import java.util.Map;
import lombok.NonNull;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

public class CustomWebSocketInterceptor
implements HandshakeInterceptor {
    public boolean beforeHandshake(ServerHttpRequest request, @NonNull ServerHttpResponse response, @NonNull WebSocketHandler wsHandler, @NonNull Map<String, Object> attributes) throws Exception {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (wsHandler == null) {
            throw new NullPointerException("wsHandler is marked non-null but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        Map paramMap = HttpUtil.decodeParamMap((String)request.getURI().getQuery(), (Charset)CharsetUtil.CHARSET_UTF_8);
        String uid = (String)paramMap.get("userId");
        if (StrUtil.isNotBlank((CharSequence)uid)) {
            attributes.put("userId", uid);
            attributes.put("ip", HttpServletUtil.currentClientIp());
            return true;
        }
        return false;
    }

    public void afterHandshake(@NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response, @NonNull WebSocketHandler wsHandler, Exception exception) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (wsHandler == null) {
            throw new NullPointerException("wsHandler is marked non-null but is null");
        }
    }
}

