/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.websocket.notifier;

import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.websocket.handler.WsSessionManager;
import com.elitesland.cbpl.tool.websocket.notifier.domain.NotifierPayload;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class WebSocketNotifier {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketNotifier.class);

    public <T extends NotifierPayload> void notify(T payload) {
        Optional<String> jsonOptional = BeanUtils.toJsonOptional(payload);
        if (jsonOptional.isEmpty()) {
            logger.warn("[PHOENIX-WS] error payload: {}", payload);
            return;
        }
        Set<String> recipients = payload.getTos();
        if (recipients != null && !recipients.isEmpty()) {
            logger.warn("[PHOENIX-WS] recipients is empty.");
            return;
        }
        TextMessage message = new TextMessage((CharSequence)jsonOptional.get());
        List<String> recipientsPushed = WsSessionManager.push(recipients, session -> this.pushToClient((WebSocketSession)session, message));
        logger.debug("[PHOENIX-WS] recipients has been pushed: {}", recipientsPushed);
    }

    private void pushToClient(WebSocketSession session, TextMessage message) {
        session.sendMessage((WebSocketMessage)message);
    }
}

