package com.elitesland.cbpl.tool.core.exceptions;

/**
 * @author eric.hao
 * @since 2023/07/10
 */
public class TryCatch {

    /**
     * tryCatch - function异常封装类
     */
    public static <T, R> R tryWrapper(TryCatchFunction<T, R> tryCatch, T arg) {
        try {
            return tryCatch.apply(arg);
        } catch (Throwable e) {
            throw ExceptionUtils.wrapRuntime(e);
        }
    }

    /**
     * tryCatch - consumer异常封装类
     */
    public static <T> void tryWrapper(TryCatchConsumer<T> tryCatch, T arg) {
        try {
            tryCatch.accept(arg);
        } catch (Throwable e) {
            throw ExceptionUtils.wrapRuntime(e);
        }
    }

    /**
     * tryCatch - supplier异常封装类
     */
    public static <T> T tryWrapper(TryCatchSupplier<T> tryCatch) {
        try {
            return tryCatch.get();
        } catch (Throwable e) {
            throw ExceptionUtils.wrapRuntime(e);
        }
    }
}
