package com.elitesland.cbpl.tool.core.io;

import cn.hutool.core.io.FileUtil;

import java.io.File;
import java.io.InputStream;

/**
 * 文件工具类
 *
 * @author eric.hao
 * @since 2023/06/11
 */
public class FileUtils extends FileUtil {

    /**
     * The System property key for the Java IO temporary directory.
     */
    private static final String JAVA_IO_TMPDIR_KEY = "java.io.tmpdir";

    /**
     * 将流的内容写入临时文件
     *
     * @param in       输入流
     * @param fileName 文件名称
     * @return 文件对象
     */
    public static File inputStreamToFile(InputStream in, String fileName) {
        File file = new File(System.getProperty(JAVA_IO_TMPDIR_KEY) + File.separator + fileName);
        if (file.exists()) {
            file.delete();
        }
        return writeFromStream(in, file);
    }
}