package com.elitesland.cbpl.tool.core.map;

import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2023/08/30
 */
public class MapUtils {

    /**
     * key、value均不为null时，则放入元素
     */
    public static <K, V> V putIfPresent(Map<K, V> map, K key, V value) {
        if (key != null && value != null) {
            return map.put(key, value);
        }
        return value;
    }

    /**
     * MultiValueMap => Map<String, String[]>
     *
     * @since 0.1.13-SNAPSHOT
     */
    public static Map<String, String[]> convert(MultiValueMap<String, String> multivalueMap) {
        Map<String, String[]> map = new HashMap<>();

        for (Map.Entry<String, List<String>> entry : multivalueMap.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            String[] array = values.toArray(new String[0]);
            map.put(key, array);
        }

        return map;
    }

    /**
     * Map<String, String[]> => MultiValueMap
     *
     * @since 0.1.13-SNAPSHOT
     */
    public static MultiValueMap<String, String> convert(Map<String, String[]> multivalueMap) {
        MultiValueMap<String, String> map = new LinkedMultiValueMap<>();

        for (Map.Entry<String, String[]> entry : multivalueMap.entrySet()) {
            map.addAll(entry.getKey(), List.of(entry.getValue()));
        }

        return map;
    }
}
