package com.elitesland.cbpl.tool.mongo.repository;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.mongo.domain.MongoDoc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.MongoTemplate;

/**
 * 存储服务提供者
 *
 * @author eric.hao
 * @since 2022/09/15
 */
@Slf4j
@RequiredArgsConstructor
public class MongoStorer {

    private static final String ERR_UNCHECKED = "MongoDB索引名称配置缺失";

    private final MongoTemplate mongoTemplate;

    /**
     * @param doc 存储对象
     */
    public <T extends MongoDoc> void save(T doc) {
        if (ObjectUtil.isEmpty(doc) || ObjectUtil.isEmpty(doc.getType())) {
            throw PhoenixException.unchecked(ERR_UNCHECKED);
        }
        save(doc, doc.getType().getStoreName());
    }

    /**
     * @param doc       存储对象
     * @param storeName 存储索引
     */
    public <T extends MongoDoc> void save(T doc, String storeName) {
        if (StrUtil.isBlank(storeName)) {
            throw PhoenixException.unchecked(ERR_UNCHECKED);
        }
        logger.debug("[MONGO] store use {}", storeName);
        mongoTemplate.insert(doc, storeName);
    }
}