/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.websocket.notifier;

import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIOServer;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.websocket.config.WebSocketProperties;
import com.elitesland.cbpl.tool.websocket.handler.WebSocketSessionManager;
import com.elitesland.cbpl.tool.websocket.notifier.domain.NotifierPayload;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;

public class WebSocketNotifier {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketNotifier.class);
    private final SocketIOServer socketIoServer;
    private final WebSocketProperties properties;

    public <T extends NotifierPayload> void notify(T payload) {
        Optional<String> jsonOptional = BeanUtils.toJsonOptional(payload);
        if (jsonOptional.isEmpty()) {
            logger.warn("[PHOENIX-WS] error payload: {}", payload);
            return;
        }
        Set<String> recipients = payload.getTos();
        if (recipients == null || recipients.isEmpty()) {
            logger.warn("[PHOENIX-WS] recipients is empty.");
            return;
        }
        TextMessage message = new TextMessage((CharSequence)jsonOptional.get());
        List<String> recipientsPushed = WebSocketSessionManager.push(recipients, session -> this.pushToClient((SocketIOClient)session, message));
        logger.debug("[PHOENIX-WS] recipients has been pushed: {}", recipientsPushed);
    }

    private void pushToClient(SocketIOClient session, TextMessage message) {
        this.socketIoServer.getNamespace(this.properties.getNamespace()).getClient(session.getSessionId()).sendEvent("channel_user", new Object[]{message});
    }

    public WebSocketNotifier(SocketIOServer socketIoServer, WebSocketProperties properties) {
        this.socketIoServer = socketIoServer;
        this.properties = properties;
    }
}

