package com.elitesland.cbpl.tool.core.exceptions;

/**
 * 自定义异常
 *
 * @author eric.hao
 * @since 2024/01/11
 */
public class PhoenixException extends RuntimeException {

    private PhoenixException(String message) {
        super(message);
    }

    private PhoenixException(String message, Throwable cause) {
        super(message, cause);
    }

    public static PhoenixException todo() {
        return new PhoenixException("[TODO] Not impl.");
    }

    public static PhoenixException unchecked(String tips) {
        return new PhoenixException("[REDO] Unchecked: " + tips);
    }

    public static PhoenixException unexpected() {
        return new PhoenixException("[REDO] Unexpected.");
    }

    public static PhoenixException unexpected(String tips) {
        return new PhoenixException("[REDO] Unexpected: " + tips);
    }

    public static PhoenixException unexpected(Throwable cause) {
        return new PhoenixException("[REDO] Unexpected.", cause);
    }
}
