package com.elitesland.cbpl.common.constant;

import lombok.Getter;

/**
 * 租户隔离策略
 *
 * @author eric.hao
 * @version 0.1.15-SNAPSHOT
 * @since 2024/06/25
 */
@Getter
public enum TenantIsolateStrategy {

    /**
     * 隔离策略
     */
    DATABASE("数据库"),
    SCHEMA("schema"),
    FIELD("表字段"),
    NONE("不隔离");

    /**
     * 描述
     */
    private final String description;

    TenantIsolateStrategy(String description) {
        this.description = description;
    }

    public String getCode() {
        return this.name();
    }
}
