package com.elitesland.cbpl.tool.core.exceptions;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.elitesland.cbpl.tool.core.util.StringUtils;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * 异常工具类
 *
 * @author eric.hao
 * @since 2023/06/11
 */
public class ExceptionUtils extends ExceptionUtil {

    /**
     * 报错堆栈信息格式化
     */
    public static String formatException(Throwable e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            sw.close();
            pw.close();
            return "\r\n" + sw + "\r\n";
        } catch (Exception e2) {
            return e.toString() + "\r\n" + e2;
        }
    }

    /**
     * 报错堆栈信息格式化，并截取最大长度
     */
    public static String formatException(Throwable e, int length) {
        return StringUtils.exceed(formatException(e), length);
    }

    /**
     * 获取最初引起异常的异常类
     *
     * @param throwable 异常
     * @since 0.1.19-SNAPSHOT
     */
    public static Throwable getCausedBy(Throwable throwable) {
        if (throwable.getCause() != null) {
            return getCausedBy(throwable.getCause());
        }
        return throwable;
    }
}
