package com.elitesland.cbpl.tool.core.io;

import cn.hutool.core.io.ManifestUtil;
import cn.hutool.core.util.ObjectUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.jar.Attributes;
import java.util.jar.Manifest;

/**
 * @author eric.hao
 * @since 2024/02/20
 */
@Slf4j
public class ManifestUtils {

    /**
     * 根据 class 获取 所在 jar 包文件的 Manifest 属性值
     *
     * @param clazz 类
     * @return Manifest
     */
    public static Attributes getMainAttributes(Class<?> clazz) {
        Manifest manifest = ManifestUtil.getManifest(clazz);
        return ObjectUtil.isEmpty(manifest) ? null : manifest.getMainAttributes();
    }

    /**
     * 根据 class 获取 所在 jar 包文件的 Manifest 属性值
     *
     * @param clazz    类
     * @param attrName 属性名称
     * @return 属性值
     */
    public static String getMainAttributesValue(Class<?> clazz, String attrName) {
        Attributes attributes = getMainAttributes(clazz);
        if (attributes != null && !attributes.isEmpty()) {
            return attributes.getValue(attrName);
        }
        return "";
    }
}
