package com.elitesland.cbpl.tool.extra.git;

import lombok.extern.slf4j.Slf4j;

import java.util.Properties;

import static com.elitesland.cbpl.tool.core.io.PropertiesUtil.loadProperties;
import static com.elitesland.cbpl.tool.extra.git.constant.GitCommitAttr.*;

/**
 * @author eric.hao
 * @since 2024/02/23
 */
@Slf4j
public class GitProperties<T> {

    private final Properties properties;

    public GitProperties(Class<T> clazz) {
        this.properties = loadProperties(clazz, GIT_PROPERTIES);
    }

    public String getBranch() {
        return properties.getProperty(GIT_COMMIT_BRANCH);
    }

    public String getCommitId() {
        return properties.getProperty(GIT_COMMIT_COMMIT_ID);
    }

    public String getBuildVersion() {
        return properties.getProperty(GIT_COMMIT_VERSION);
    }

    public String getRemoteUrl() {
        return properties.getProperty(GIT_COMMIT_REMOTE_URL);
    }
}
