package com.elitesland.cbpl.tool.websocket.constant;

/**
 * @author eric.hao
 * @since 2024/11/18
 */
public class WebSocketConstant {

    /**
     * 游客身份的UserId、登录账号、昵称
     */
    public static final String GUEST_USER_ID = "G_9";
    public static final String GUEST_USERNAME = "GUEST";
    public static final String GUEST_NICKNAME = "游客";
    public static final String GUEST_TENANT_CODE = "-1";

    /**
     * 客户端，指纹ID
     */
    public static final String VISITOR_ID = "visitorId";

    /**
     * Socket事件类
     */
    public static class SocketEvent {

        /**
         * 心跳检查
         */
        public static final String HEALTH_CHECK = "actuator";

        /**
         * 消息接收 - 简单事件
         */
        public static final String MESSAGE = "message";

        /**
         * 消息推送 - 用户频道
         **/
        public static final String CHANNEL_USER = "channel_user";

        /**
         * 消息推送 - 系统频道
         **/
        public static final String CHANNEL_SYSTEM = "channel_system";
    }
}
