package com.elitesland.cbpl.tool.core.io;

import lombok.SneakyThrows;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

/**
 * @author eric.hao
 * @since 2024/02/24
 */
public class PropertiesUtil {

    /**
     * 从当前的类加载器的`getResourcesAsStream`来获取`Properties`
     *
     * @param clazz    指定类
     * @param filePath 文件路径(填写resources目录下的相对路径)
     * @param <T>      对象类型
     * @return Properties
     */
    @SneakyThrows
    public static <T> Properties loadProperties(Class<T> clazz, String filePath) {
        InputStream inputStream = clazz.getClassLoader().getResourceAsStream(filePath);
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }

    /**
     * 读取所有jar包相同的配置文件
     *
     * @param filePath 文件路径(填写resources目录下的相对路径)
     * @return Properties
     */
    @SneakyThrows
    public static List<Properties> loadProperties(String filePath) {
        List<Properties> result = new ArrayList<>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> enums = classLoader.getResources(filePath);
        while (enums.hasMoreElements()) {
            URL tme = enums.nextElement();
            // 通过UrlConnection获取输入流
            InputStream in = tme.openConnection().getInputStream();
            // 将输入流转化为Properties类
            Properties properties = new Properties();
            properties.load(in);
            result.add(properties);
        }
        return result;
    }
}
