package com.elitesland.cbpl.tool.core.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.StrPool;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;

import java.util.Arrays;

/**
 * 字符串相关工具类
 *
 * @author eric.hao
 * @since 2023/06/11
 */
public class StringUtils extends StrUtil {

    /**
     * 默认字符串限制长度
     */
    public static final int DEFAULT_EXCEED_LENGTH = 255;

    /**
     * 异常信息 最大长度
     *
     * @since 0.1.12-SNAPSHOT
     */
    public static final int ERROR_EXCEED_LENGTH = 2000;

    /**
     * 字符串添加双引号
     */
    public static String brackets(String obj) {
        return "\"" + trimToEmpty(obj) + "\"";
    }

    /**
     * String/Object[] => String[]
     */
    public static String[] toArray(Object paramStr) {
        if (BeanUtil.isEmpty(paramStr)) {
            return new String[]{};
        }
        return paramStr instanceof String ? new String[]{(String) paramStr} : resolveArr((Object[]) paramStr);
    }

    /**
     * Object[] => String[]
     */
    private static String[] resolveArr(Object[] paramArr) {
        return Arrays.copyOf(paramArr, paramArr.length, String[].class);
    }

    /**
     * 限制字符串长度（默认最大长度255）
     *
     * @param source 字符串
     * @return 截取后字符串
     */
    public static String exceed(CharSequence source) {
        return exceed(source, DEFAULT_EXCEED_LENGTH);
    }

    /**
     * 限制字符串长度
     *
     * @param source 字符串
     * @param length 最大长度
     * @return 截取后字符串
     */
    public static String exceed(CharSequence source, int length) {
        Assert.isTrue(length > 0);
        if (null == source) {
            return null;
        }
        if (source.length() <= length) {
            return source.toString();
        }
        return sub(source, 0, length);
    }

    /**
     * 按租户拼接业务主键
     *
     * @param values 主键相关字符
     * @return 拼接后主键
     * @since 0.1.13-SNAPSHOT
     */
    public static String tenantKey(String... values) {
        return tenantKey(StrPool.UNDERLINE, values);
    }

    /**
     * 按租户拼接业务主键
     *
     * @param conjunction 分隔符 {@link StrPool#UNDERLINE}
     * @param values      主键相关字符
     * @return 拼接后主键
     * @since 0.1.13-SNAPSHOT
     */
    public static String tenantKey(CharSequence conjunction, String... values) {
        String tenantCode = TenantSpiUtil.currentTenantCode();
        // tenantCode为空，或等于 'null' 字符串
        if (StrUtil.isBlank(tenantCode) || StrUtil.NULL.equals(tenantCode)) {
            return StrUtil.join(conjunction, values);
        }
        return StrUtil.join(conjunction, tenantCode, values);
    }
}