package com.elitesland.cbpl.tool.db;

import cn.hutool.core.collection.CollUtil;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/01/17
 */
@Data
public class PagingVO<T extends Serializable> implements Serializable {

    /**
     * 总记录数
     */
    private long total;

    /**
     * 数据列表
     */
    private List<T> records;

    public PagingVO(long total, List<T> records) {
        this.total = total;
        this.records = CollUtil.emptyIfNull(records);
    }

    public PagingVO() {
        this(0, null);
    }
}
