package com.elitesland.cbpl.tool.iam;

import cn.hutool.extra.spring.SpringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/**
 * 当前登录用户
 *
 * @author eric.hao
 * @since 2024/12/23
 */
@Slf4j
public class IamSpiUtil {

    /**
     * 是否已登录
     *
     * @since 0.1.19-SNAPSHOT
     */
    public static boolean isLogin() {
        try {
            IamUserSpi iamUser = SpringUtil.getBean(IamUserSpi.class);
            return iamUser.isLogin();
        } catch (NoSuchBeanDefinitionException e) {
            logger.warn("[PHOENIX-IAM] IamUserSpi NoSuchBeanDefinition");
        }
        return false;
    }

    public static Long currentUserId() {
        try {
            IamUserSpi iamUser = SpringUtil.getBean(IamUserSpi.class);
            return iamUser.currentUserId();
        } catch (NoSuchBeanDefinitionException e) {
            logger.warn("[PHOENIX-IAM] IamUserSpi NoSuchBeanDefinition");
        }
        return null;
    }

    public static String currentUserIdStr() {

        try {
            IamUserSpi iamUser = SpringUtil.getBean(IamUserSpi.class);
            return iamUser.currentUserIdStr();
        } catch (NoSuchBeanDefinitionException e) {
            logger.warn("[PHOENIX-IAM] IamUserSpi NoSuchBeanDefinition");
        }
        return null;
    }
}
