package com.elitesland.cbpl.tool.websocket.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.elitesland.cbpl.tool.websocket.config.WebSocketProperties.WX_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2022/09/14
 */
@Data
@ConfigurationProperties(prefix = WX_CONFIG_PREFIX)
public class WebSocketProperties {

    public static final String WX_CONFIG_PREFIX = "cbpl.tool.ws";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    /**
     * 服务端IP
     */
    @Deprecated
    private String host = "127.0.0.1";

    /**
     * 服务端端口
     */
    private Integer port = 9000;

    /**
     * WebSocket 接口路径
     * <li>供 WebSocket 或 SockJS客户端 访问的地址</li>
     */
    private String namespace = "/webSocket";

    /**
     * Socket接口路径
     * <li>服务器和客户端的值必须匹配（除非您在其间使用路径重写代理）。</li>
     */
    private String contextPath = "/socket.io";

    /**
     * Socket连接数大小（如只监听一个端口boss线程组为1即可）
     */
    private int bossCount = 1;

    /**
     * 工作线程，默认100
     */
    private int workCount = 100;

    /**
     * 允许自定义请求头
     */
    private boolean allowCustomRequests = true;

    /**
     * This is the delay in milliseconds before an uncompleted transport upgrade is cancelled.
     * <li>协议升级超时时长(毫秒)，默认10000。HTTP握手升级为ws协议超时时间</li>
     */
    private int upgradeTimeout = 10000;

    /**
     * 心跳检查超时时长(毫秒)，默认20000
     * <li>注意：如果您需要在应用程序中发送大文件，则默认值可能会有点低。</li>
     */
    private int pingTimeout = 20000;

    /**
     * 心跳间隔时长(毫秒)，默认25000
     * <li>如果客户端在ms内没有收到服务端的ping（pingInterval + pingTimeout）</li>
     * <li>那么客户端也认为连接关闭了。</li>
     */
    private int pingInterval = 25000;

    /**
     * WebSocket 许可域名
     * <li>如果是关闭跨域校验，这里可以配置「*」</li>
     */
    private String[] allow;
}
