package com.elitesland.cbpl.tool.websocket.spi;

import com.corundumstudio.socketio.HandshakeData;
import com.elitesland.cbpl.tool.websocket.handler.domain.OnlineUser;

/**
 * @author eric.hao
 * @since 2024/11/21
 */
public interface OnlineListener {

    /**
     * 根据「Authorization」解析出「UserId」
     */
    String getUserId(HandshakeData request);

    /**
     * 根据「Authorization」解析出登录账号
     */
    String getUsername(HandshakeData request);

    /**
     * 根据「Authorization」解析出昵称
     */
    String getNickname(HandshakeData request);

    /**
     * 根据「Authorization」解析出租户编码
     */
    String getTenantCode(HandshakeData request);

    /**
     * 添加在线用户
     */
    void add(OnlineUser user);

    /**
     * 删除在线用户
     */
    void remove(OnlineUser user);

    /**
     * 根据「userId」查询登录账号
     *
     * @since 0.1.19-SNAPSHOT
     */
    String getUsernameByUserId(Long userId);

    /**
     * 根据「userId」查询昵称
     *
     * @since 0.1.19-SNAPSHOT
     */
    String getNicknameByUserId(Long userId);
}
