package com.elitesland.cbpl.tool.websocket.util;

import cn.hutool.core.collection.CollUtil;
import com.corundumstudio.socketio.SocketIOClient;
import com.elitesland.cbpl.tool.websocket.constant.WebSocketConstant;
import io.netty.handler.codec.http.HttpHeaders;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2024/12/18
 */
@Slf4j
public class WebSocketUtil {

    /**
     * 获取握手信息的头参数
     */
    public static String getHeader(SocketIOClient session, String key) {
        try {
            HttpHeaders headers = session.getHandshakeData().getHttpHeaders();
            return headers.get(key);
        } catch (Exception e) {
            logger.error("[PHOENIX-WS] get http header({}) error.", key, e);
        }
        return null;
    }

    /**
     * 获取url参数
     */
    public static String getUrlParams(SocketIOClient session, String key) {
        Map<String, List<String>> urlParams = session.getHandshakeData().getUrlParams();
        List<String> params = urlParams.get(key);
        if (CollUtil.isNotEmpty(params)) {
            return params.get(0);
        }
        return null;
    }

    /**
     * 获取当前会话中的指纹ID
     */
    public static String getVisitorId(SocketIOClient session) {
        return WebSocketUtil.getHeader(session, WebSocketConstant.VISITOR_ID);
    }
}
