package com.elitesland.cbpl.tool.core.date;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.format.FastDateFormat;

import java.util.Date;

/**
 * 时间工具类
 *
 * @author eric.hao
 * @since 2023/06/13
 */
public class DateUtils extends DateTime {

    /**
     * 点符号分隔符的日期格式：yyyy.MM.dd
     */
    public static final String DOT_DATE_PATTERN = "yyyy.MM.dd";

    /**
     * 点符号分隔符的日期格式 {@link FastDateFormat}：yyyy.MM.dd
     */
    public static final FastDateFormat DOT_DATE_FORMAT = FastDateFormat.getInstance(DOT_DATE_PATTERN);

    /**
     * 当前日期，格式 yyyy.MM.dd
     *
     * @return 当前日期的标准形式字符串
     */
    public static String todayDot() {
        return DOT_DATE_FORMAT.format(new Date());
    }

    /**
     * 现在的时间
     *
     * @return 格式字符串 yyyy-MM-dd HH:mm:ss
     */
    public static String nowStr() {
        return DateTime.now().toString();
    }
}
