package com.elitesland.cbpl.tool.db.entity;

import com.elitesland.cbpl.tool.db.constant.IdGeneratorStrategy;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author eric.hao
 * @since 2024/01/11
 */
@Getter
@Setter
@Accessors(chain = true)
@MappedSuperclass
public abstract class BaseEntity implements Serializable {

    @Id
    @GenericGenerator(name = "phoenix-id", strategy = IdGeneratorStrategy.DEFAULT)
    @GeneratedValue(strategy = GenerationType.AUTO, generator = "phoenix-id")
    @Comment("唯一标识")
    @Column()
    private Long id;

    @Comment("记录创建者ID")
    @Column(updatable = false)
    private Long createUserId;

    @Comment("记录创建者")
    @Column()
    private String creator;

    @CreationTimestamp
    @Comment("记录创建时间")
    @Column(updatable = false)
    private LocalDateTime createTime;

    @Comment("记录最后更新者ID")
    @Column()
    private Long modifyUserId;

    @Comment("记录最后更新者")
    @Column()
    private String updater;

    @UpdateTimestamp
    @Comment("记录最后更新时间")
    @Column()
    private LocalDateTime modifyTime;

    @Comment(value = "删除标记")
    @Column()
    private Integer deleteFlag = 0;

    @Comment("备注")
    @Column()
    private String remark;
}
