package com.elitesland.cbpl.tool.tenant;

import java.util.function.Supplier;

/**
 * @author eric.hao
 * @since 2024/01/16
 */
public interface TenantClientSpi<T> {

    /**
     * 查询所有租户下的接口地址及账号
     *
     * @param executor 查询方法
     */
    void byTenants(Runnable executor);

    /**
     * 直接使用指定的租户
     * <p>
     * 以Runnable函数式接口类型为参数，没有返回结果
     *
     * @param executor   业务侧执行方法
     * @param tenantCode 租户编码
     */
    void byTenantDirectly(Runnable executor, String tenantCode);

    /**
     * 直接使用指定的租户
     * <p>
     * 以Supplier函数式接口类型为参数，返回结果类型为E
     *
     * @param executor   业务操作
     * @param tenantCode 租户编码
     * @param <E>        数据类型
     * @return 数据
     */
    <E> E byTenantDirectly(Supplier<E> executor, String tenantCode);

    /**
     * 设置当前租户Session
     *
     * @param tenant 租户相关配置
     */
    void setCurrentTenant(T tenant);

    /**
     * 清除当前租户的Session
     */
    void resetCurrentTenant();

    /**
     * 当前租户编码
     *
     * @return 租户编码
     */
    String currentTenantCode();
}
