package com.elitesland.cbpl.tool.api.domain;

import com.elitesland.cbpl.common.base.ResponseVO;
import lombok.Data;

import javax.annotation.Nullable;
import java.util.Date;

/**
 * @author eric.hao
 * @since 2024/01/17
 */
@Data
public class HttpResult<T> extends ResponseVO {

    /**
     * 错误号
     */
    @Nullable
    private String errorNo;

    /**
     * 响应数据
     */
    @Nullable
    private T data;

    public static <T> HttpResult<T> ok(T data) {
        HttpResult<T> result = new HttpResult<>();
        result.setCode(200);
        result.setData(data);
        result.setTime(new Date());
        return result;
    }

    public static <T> HttpResult<T> ok() {
        return ok(null);
    }
}
