package com.elitesland.cbpl.common.base;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author eric.hao
 * @since 2024/01/17
 */
@Data
public abstract class ResponseVO implements Serializable {

    private static final long serialVersionUID = -7204196611638488980L;

    /**
     * 响应码
     */
    private int code;

    /**
     * 响应消息
     */
    private String msg;

    /**
     * 链路跟踪ID
     */
    private String traceId;

    /**
     * 响应时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date time;
}