package com.elitesland.cbpl.tool.db;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.db.Page;
import com.elitesland.cbpl.tool.db.util.PageOrder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.PathBuilderValidator;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.Data;

import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2024/01/17
 */
@Data
public class PageQueryParam extends Page implements Serializable {

    @JsonIgnore
    public void setPaging(JPAQuery<?> query) {
        query.offset((long) getPageNumber() * getPageSize());
        query.limit(getPageSize());
    }

    @JsonIgnore
    public void fillOrders(JPAQuery<?> query, EntityPathBase<?> entityPathBase) {
        if (ArrayUtil.isEmpty(getOrders())) return;
        PathBuilder orderByExpr = new PathBuilder<>(entityPathBase.getClass(), entityPathBase.getMetadata(), PathBuilderValidator.FIELDS);
        for (cn.hutool.db.sql.Order order : getOrders()) {
            OrderSpecifier orderSpecifier = new OrderSpecifier(
                    PageOrder.isAscending(order) ? Order.ASC : Order.DESC, orderByExpr.get(order.getField())
            );
            query.orderBy(orderSpecifier);
        }
    }
}
