package com.elitesland.cbpl.tool.tenant;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

/**
 * @author eric.hao
 * @since 2024/01/17
 */
public interface TenantAsyncSpi {


    /**
     * 异步线程封装：会根据Session切换当前租户
     * <p>
     * 以Supplier函数式接口类型为参数，返回结果类型为T；Supplier接口的 get()是有返回值的(会阻塞)
     *
     * @param executor 业务侧执行方法
     * @return 异步对象
     */
    default <T> CompletableFuture<T> supplyAsync(Supplier<T> executor) {
        return supplyAsync(executor, TenantSpiUtil.currentTenantCode());
    }

    /**
     * 异步线程封装：会根据Session切换当前租户
     * <p>
     * 以Supplier函数式接口类型为参数，返回结果类型为T；Supplier接口的 get()是有返回值的(会阻塞)
     *
     * @param executor   业务侧执行方法
     * @param tenantCode 租户编码
     * @return 异步对象
     */
    <T> CompletableFuture<T> supplyAsync(Supplier<T> executor, String tenantCode);


    /**
     * 异步线程封装：会根据Session切换当前租户
     * <p>
     * 以Runnable函数式接口类型为参数，没有返回结果
     *
     * @param executor 业务侧执行方法
     * @return 异步对象
     */
    default <T> CompletableFuture<Void> runAsync(Runnable executor) {
        return runAsync(executor, TenantSpiUtil.currentTenantCode());
    }

    /**
     * 异步线程封装：会根据Session切换当前租户
     * <p>
     * 以Runnable函数式接口类型为参数，没有返回结果
     *
     * @param executor   业务侧执行方法
     * @param tenantCode 租户编码
     * @return 异步对象
     */
    <T> CompletableFuture<Void> runAsync(Runnable executor, String tenantCode);
}
