package com.elitesland.cbpl.tool.tenant;

import cn.hutool.core.text.StrPool;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/**
 * @author eric.hao
 * @since 2024/01/16
 */
public class TenantSpiUtil {

    /**
     * 当前租户编码
     *
     * @return 租户编码
     */
    public static String currentTenantCode() {
        try {
            TenantClientSpi<?> tenantClient = SpringUtil.getBean(TenantClientSpi.class);
            return tenantClient.currentTenantCode();
        } catch (NoSuchBeanDefinitionException e) {
            return "";
        }
    }

    /**
     * 租户前缀 (tenantCode_)
     *
     * @return 前缀
     */
    public static String tenantPrefix() {
        return tenantPrefix(StrPool.C_UNDERLINE);
    }

    /**
     * 租户前缀 (tenantCode_)
     *
     * @return 前缀
     */
    public static String tenantPrefix(char prefix) {
        String tenantCode = currentTenantCode();
        return StrUtil.isBlank(tenantCode) ? "" : tenantCode + prefix;
    }
}
