package com.elitesland.cbpl.tool.core.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;

import java.util.Arrays;

/**
 * 字符串相关工具类
 *
 * @author eric.hao
 * @since 2023/06/11
 */
public class StringUtils extends StrUtil {

    public static final int DEFAULT_EXCEED_LENGTH = 255;

    /**
     * 字符串添加双引号
     */
    public static String brackets(String obj) {
        return "\"" + trimToEmpty(obj) + "\"";
    }

    /**
     * String/Object[] => String[]
     */
    public static String[] toArray(Object paramStr) {
        if (BeanUtil.isEmpty(paramStr)) {
            return new String[]{};
        }
        return paramStr instanceof String ? new String[]{(String) paramStr} : resolveArr((Object[]) paramStr);
    }

    /**
     * Object[] => String[]
     */
    private static String[] resolveArr(Object[] paramArr) {
        return Arrays.copyOf(paramArr, paramArr.length, String[].class);
    }

    /**
     * 限制字符串长度（默认最大长度255）
     *
     * @param source 字符串
     * @return 截取后字符串
     */
    public static String exceed(CharSequence source) {
        return exceed(source, DEFAULT_EXCEED_LENGTH);
    }

    /**
     * 限制字符串长度
     *
     * @param source 字符串
     * @param length 最大长度
     * @return 截取后字符串
     */
    public static String exceed(CharSequence source, int length) {
        Assert.isTrue(length > 0);
        if (null == source) {
            return null;
        }
        if (source.length() <= length) {
            return source.toString();
        }
        return sub(source, 0, length);
    }
}