/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.mongo.repository;

import com.elitesland.cbpl.tool.db.PageQueryParam;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.tool.mongo.domain.MongoDoc;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;

public abstract class MongoQuery
extends PageQueryParam {
    private static final Logger logger = LoggerFactory.getLogger(MongoQuery.class);

    public abstract String getStoreName();

    protected abstract Query buildQuery();

    public <T extends MongoDoc> PagingVO<T> paging(MongoTemplate template, Class<T> entityClass) {
        Query query = this.buildQuery();
        long total = template.count(query, this.getStoreName());
        if (total > 0L) {
            List rows = template.find(this.withPaging(query), entityClass, this.getStoreName());
            return new PagingVO(total, rows);
        }
        return new PagingVO();
    }

    public long count(MongoTemplate template) {
        return template.count(this.buildQuery(), this.getStoreName());
    }

    public <T> List<T> find(MongoTemplate template, Class<T> entityClass) {
        return template.find(this.withSorting(this.buildQuery()), entityClass, this.getStoreName());
    }

    private Query withPaging(Query query) {
        if ((long)this.getPageNumber() > 0L) {
            int offset = this.getPageNumber() * this.getPageSize();
            query.skip((long)offset);
        }
        if ((long)this.getPageSize() > 0L) {
            query.limit(this.getPageSize());
        }
        return this.withSorting(query);
    }

    private Query withSorting(Query query) {
        Sort timeSort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        query.with(timeSort);
        logger.info("[MONGO] query: {}", (Object)query);
        return query;
    }
}

