package com.elitesland.supp.dto;


import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:品项采购价格
 * </p>
 *
 * @Author Darren
 * @Version 1.0
 * @Content:
 * @Date 2021/02/24
 */
@Data
@ApiModel("品项采购价格查询入参")
public class PurPurcPriceParamDTO  implements Serializable {
    private static final long serialVersionUID = -17725475010168501L;

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long suppId;

    @ApiModelProperty("商品ids")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> itemIds;

    @ApiModelProperty(value = "商品和供应商是否绑定")
    private String bindStatus;

}
