package com.elitesland.supp.dto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.val;

import java.io.Serial;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 用户数据权限
 *
 * @author Jeff.ni
 * @since 2018-06-14
 */
@ApiModel("用户数据权限")
@Data
public class YstUserDataPowerDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = 7051260034688823978L;
    /**
     * 用户ID
     */
    @ApiModelProperty("用户ID")
    private long userId;

    /**
     * 公司权限标识 A:所有权限；O：指定具体权限；同一用户，同一权限维度，A与O 互斥；
     */
    @ApiModelProperty("公司权限标识")
    private YstDataPowerFlagDTO ouPowerFlag;

    /**
     * 公司编码
     */
    @ApiModelProperty("公司编码")
    private List<String> ouCodes = new ArrayList<>();

}
