package com.elitesland.supp.outprovider;


import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.supp.dto.SrmPurSuppDTO;
import com.elitesland.supp.dto.SrmUserRelateParamDTO;
import com.elitesland.supp.dto.SrmUserRelateRpcDTO;

import java.util.List;

/**
 * @author: 王鑫华
 * @date: 2021/6/25
 */
@Unicom(domain = "cbpl-srm")
public interface SrmPurSuppOutProvider {

    /**
     *  模糊
     * @param suppCodeName 供应商编码或者名称
     * @return
     */
    List<SrmPurSuppDTO> findBylikeSuppCodeOrName(String suppCodeName);

    /**
     * 根据供应商DTO入参查询供应商部分信息:用于Provider层DTO里的UDC转换
     *
     * @param suppcodes 供应商DTO入参
     * @return 供应商部分信息出参对象
     */
    List<SrmPurSuppDTO> findBySuppCodes(List<String> suppCodes);

    /**
     * 根据ID查询
     * @param ids
     * @return
     */
    List<SrmPurSuppDTO> findById(List<Long> ids);


    /**
     * 根据供应商类型或者供应商id获取用户信息
     */

   List<SrmUserRelateRpcDTO> findUserRelateDTOList(SrmUserRelateParamDTO paramDTO);

}
