package com.elitesland.cbpl.srm.supp.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;

/**
 * @author: 王鑫华
 * @date: 2021/6/25
 */
@ApiModel(description = "供应商主档返回详情参数对象")
@Data
public class SrmPurSuppDTO  implements Serializable {
    @Serial
    private static final long serialVersionUID = 1590985189553412326L;
    /**
     * 平台信息
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "id")
    private Long id;
    @ApiModelProperty(value = "供应商编码")
    private String suppCode;

    @SysCode(sys = "SUPP", mod = "SUPP_TYPE")
    private String suppType;
    private String suppTypeName;
    @ApiModelProperty("供应商名称")
    private String suppName;
    @ApiModelProperty("企业(供应商)简称")
    private String suppAbbr;
    @ApiModelProperty("税率编码")
    private String taxRateNo;
}

