package com.elitesland.srm.iam.domain;

import com.elitesland.srm.supplier.record.archive.ou.entity.SuppOuDO;
import lombok.Data;

import java.io.Serializable;

/**
 * 供应商用户
 *
 * @author eric.hao
 * @since 2022/04/25
 */
@Data
public class SuppUserContext implements Serializable {

    private static final long serialVersionUID = -8959086849364027831L;

    /**
     * 供应商id
     */
    private Long suppId;

    /**
     * 供应商编号
     */
    private String suppCode;

    /**
     * 供应商名称
     */
    private String suppName;

    public static SuppUserContext of(SuppOuDO suppOuDO) {
        SuppUserContext suppCtx = new SuppUserContext();
        suppCtx.setSuppId(suppOuDO.getSuppId());
        suppCtx.setSuppCode(suppOuDO.getSuppCode());
        suppCtx.setSuppName(suppOuDO.getSuppName());
        return suppCtx;
    }
}
