package com.elitesland.srm.iam.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cloudt.authorization.core.SecurityContextUtil;
import com.elitesland.srm.iam.domain.SrmIamExtInfo;
import com.elitesland.srm.iam.domain.SuppUserContext;
import com.elitesland.srm.util.error.SrmException;
import com.elitesland.yst.security.dto.SecurityOrgUserEmpBuDTO;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @author eric.hao
 * @since 2022/03/22
 */
@Slf4j
public class SrmIamUtil {

    /**
     * 当前登录人 - 所有扩展信息
     */
    public static SrmIamExtInfo currentUserExtInfo() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (ObjectUtil.isNull(user)) {
            throw SrmException.unauthorizedException();
        }
        SrmIamExtInfo extInfo = Optional.ofNullable((SrmIamExtInfo) user.getExtendInfo()).orElse(new SrmIamExtInfo());
        logger.debug("[SRM-IAM] extension info={}", extInfo);
        return extInfo;
    }

    /**
     * 当前登录人 - 供应商扩展信息
     */
    public static SuppUserContext suppContext() {
        SrmIamExtInfo extInfo = currentUserExtInfo();
        return extInfo.getSuppContext();
    }

    /**
     * 当前登录人 - 是供应商角色
     */
    public static boolean isSupplier() {
        return ObjectUtil.isNotNull(suppContext());
    }

    /**
     * 当前登录人 - 不是供应商角色
     */
    public static boolean isNotSupplier() {
        return ObjectUtil.isNull(suppContext());
    }

    private static final String ERROR_NOT_SUPPLIER = "当前账号不是供应商，请检查";

    /**
     * 当前登录人 - 供应商id
     * 不是供应商角色，会报错
     */
    public static Long currentSuppId() {
        SuppUserContext suppContext = suppContext();
        if (ObjectUtil.isNull(suppContext)) {
            throw SrmException.parameterException(ERROR_NOT_SUPPLIER);
        }
        return suppContext.getSuppId();
    }

    /**
     * 当前登录人 - 供应商编号
     * 不是供应商角色，会报错
     */
    public static String currentSuppCode() {
        SuppUserContext suppContext = suppContext();
        if (ObjectUtil.isNull(suppContext)) {
            throw SrmException.parameterException(ERROR_NOT_SUPPLIER);
        }
        return suppContext.getSuppCode();
    }

    /**
     * 当前登录人 - 供应商名称
     * 不是供应商角色，会报错
     */
    public static String currentSuppName() {
        SuppUserContext suppContext = suppContext();
        if (ObjectUtil.isNull(suppContext)) {
            throw SrmException.parameterException(ERROR_NOT_SUPPLIER);
        }
        return suppContext.getSuppName();
    }

    private static final String ERROR_NOT_BIND_EMP = "当前账号未绑定员工，请检查";

    /**
     * 当前登录人 - 员工
     */
    private static SecurityOrgUserEmpBuDTO orgEmpContext() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (ObjectUtil.isNull(user)) {
            throw SrmException.unauthorizedException();
        }
        SecurityOrgUserEmpBuDTO orgEmp = user.getSecurityOrgUserEmpBuDTO();
        if (ObjectUtil.isNull(orgEmp)) {
            throw SrmException.parameterException(ERROR_NOT_BIND_EMP);
        }
        return orgEmp;
    }

    /**
     * 获取当前登录用户分部
     */
    public static Long currentBuId() {
        SecurityOrgUserEmpBuDTO orgEmp = orgEmpContext();
        List<Long> buIds = Optional.ofNullable(orgEmp.getEmpBuIds()).orElse(new ArrayList<>());
        return CollUtil.isNotEmpty(buIds) ? buIds.get(0) : 0L;
    }

    /**
     * 当前登录人 - 员工id
     * 未绑定员工，会报错
     */
    public static Long currenEmpId() {
        SecurityOrgUserEmpBuDTO orgEmp = orgEmpContext();
        return orgEmp.getEmpId();
    }
}
