package com.elitesland.srm.supplier.biz.service;

import com.elitesland.cbpl.unicom.annotation.Unicom;

/**
 * 供应商相关校验
 *
 * @author eric.hao
 * @since 2022/12/26
 */
@Unicom
public interface SuppValidateService<T> {

    /**
     * 校验短信验证码
     *
     * @param mobile  手机号
     * @param captcha 验证码
     * @return 校验结果
     */
    boolean checkMobileSmsCaptcha(String mobile, String captcha);

    /**
     * 供应商注册校验
     *
     * @param saveParam 供应商注册参数
     * @return 校验是否通过
     */
    boolean registerValidate(T saveParam);

    /**
     * 供应商名称是否重复
     *
     * @param suppId   供应商id
     * @param suppName 供应商名称
     */
    boolean existsBySuppName(Long suppId, String suppName);
}
