package com.elitesland.srm.supplier.record.archive.addtion.entity;

import com.elitesland.yst.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 业务信息补充表
 *
 * @author eric.hao
 * @since 2022/11/09
 */
@Entity
@Table(name = "srm_supp_biz")
@org.hibernate.annotations.Table(appliesTo = "srm_supp_biz", comment = "业务信息补充表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SrmSuppBizDO extends BaseModel implements Serializable {

    @Comment(value = "供应商ID")
    @Column()
    private Long suppId;

    @Comment(value = "供应商编码")
    @Column()
    private String suppCode;

    @Comment(value = "供应商名称")
    @Column()
    private String suppName;

    @Comment(value = "所属部门")
    @Column()
    private String belongDept;

    @Comment(value = "考核等级")
    @Column()
    private String examineGrade;

    @Comment(value = "考核时间")
    @Column()
    private LocalDateTime examineTime;

    @Comment(value = "供货区域")
    @Column()
    private String suppRegion;

    @Comment(value = "供应渠道")
    @Column()
    private String suppChannel;

    @Comment(value = "配送方式")
    @Column()
    private String shipMethod;

    @Comment(value = "对账周期")
    @Column()
    private String reconPeriod;

    @Comment(value = "绩效管理周期")
    @Column()
    private String performancePeriod;
}
