package com.elitesland.srm.supplier.record.archive.addtion.entity;

import com.elitesland.yst.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 基础信息补充表
 *
 * @author eric.hao
 * @since 2022/11/09
 */
@Entity
//@Table(name = "srm_supp_add")
@org.hibernate.annotations.Table(appliesTo = "srm_supp_add", comment = "基础信息补充表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SuppAddDO extends BaseModel implements Serializable {

    @Comment(value = "供应商ID")
    @Column()
    private Long suppId;

    @Comment(value = "供应商编码")
    @Column()
    private String suppCode;

    @Comment(value = "供应商名称")
    @Column()
    private String suppName;

    @Comment(value = "服务品牌")
    @Column()
    private String serviceBrand;

    @Comment(value = "厂房性质")
    @Column()
    private String plantNature;

    @Comment(value = "厂房总面积")
    @Column()
    private String plantArea;

    @Comment(value = "生产面积")
    @Column()
    private String prodArea;

    @Comment(value = "成品库面积")
    @Column()
    private String fpwArea;

    @Comment(value = "原料库面积")
    @Column()
    private String rmwArea;

    @Comment(value = "冷冻冷藏库面积")
    @Column()
    private String cswArea;

    @Comment(value = "主营品类")
    @Column()
    private String mainCategory;

    @Comment(value = "工厂员工数")
    @Column()
    private Integer factoryEmployeesNumber;

    @Comment(value = "管理人数")
    @Column()
    private Integer managementPeopleNumber;

    @Comment(value = "开发技术人数")
    @Column()
    private Integer technologyPeopleNumber;

    @Comment(value = "品质检验人数")
    @Column()
    private Integer qualityInspectionNumber;

    @Comment(value = "认证体系")
    @Column()
    private String certificationSystem;

    @Comment(value = "主要生产设备")
    @Column()
    private String mainProductionEquipment;

    @Comment(value = "产品执行标准")
    @Column()
    private String productPerformanceStandards;

    @Comment(value = "质量检验")
    @Column()
    private String qualityInspection;

    @Comment(value = "检验范围")
    @Column()
    private String inspectionScope;

    @Comment(value = "供货质量记录")
    @Column()
    private String deliveryQualityRecord;

    @Comment(value = "体系认证")
    @Column()
    private String systemCert;

    @Comment(value = "销售模式")
    @Column()
    private String salesModel;

    @Comment(value = "去年产值")
    @Column()
    private String yearProduction;

    @Comment(value = "供应商愿景")
    @Column()
    private String suppVision;

    @Comment(value = "供应商目标")
    @Column()
    private String suppTarget;
}
