package com.elitesland.srm.supplier.record.archive.ou.entity;

import com.elitesland.yst.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 公司关联业务
 *
 * @author eric.hao
 * @since 2022/11/09
 */
@Entity
@Table(name = "srm_supp_ou")
@org.hibernate.annotations.Table(appliesTo = "srm_supp_ou", comment = "公司关联业务")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SuppOuDO extends BaseModel implements Serializable {

    @Comment(value = "地址号")
    @Column()
    private String addrNo;

    @Comment(value = "供应商ID")
    @Column()
    private Long suppId;

    @Comment(value = "供应商编码")
    @Column()
    private String suppCode;

    @Comment(value = "供应商名称")
    @Column()
    private String suppName;

    @Comment(value = "供应商状态")
    @Column()
    private String suppStatus;

    @Comment(value = "公司ID")
    @Column()
    private Long ouId;

    @Comment(value = "公司编码")
    @Column()
    private String ouCode;

    @Comment(value = "公司名称")
    @Column()
    private String ouName;

    @Comment(value = "准入负责人")
    @Column()
    private Long sponsorUserId;

    @Comment(value = "准入负责人姓名")
    @Column()
    private String sponsorUserName;

    @Comment(value = "合格日期")
    @Column()
    private LocalDate qualifyDate;

    @Comment(value = "淘汰日期")
    @Column()
    private LocalDate eliminateDate;

    @Comment(value = "标记类别")
    @Column()
    private String tag;

    @Comment(value = "黑名单原因")
    @Column()
    private String blockReason;

    @Comment(value = "ERP编码")
    @Column()
    private String suppErpCode;

    @Comment(value = "器械统一码")
    @Column()
    private String deviceUnicode;

    @Comment(value = "接口状态")
    @Column()
    private String intfStatus;

    @Comment(value = "接口处理时间")
    @Column()
    private LocalDateTime intfTime;
}
