package com.elitesland.srm.supplier.record.archive.supp.entity;

import com.elitesland.yst.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 供应商主数据
 *
 * @author eric.hao
 * @since 2022/03/22
 */
@Entity
@Table(name = "srm_supp")
@org.hibernate.annotations.Table(appliesTo = "srm_supp", comment = "供应商主数据")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SupplierDO extends BaseModel implements Serializable {

    @Comment(value = "地址号")
    @Column()
    private Long addrNo;

    @Comment(value = "供应商编码")
    @Column()
    private String suppCode;

    @Comment(value = "供应商名称")
    @Column()
    private String suppName;

    @Comment(value = "企业简称")
    @Column()
    private String suppAbbr;

    @Comment(value = "英文名称")
    @Column()
    private String englishName;

    @Comment(value = "供应商状态")
    @Column()
    private String suppStatus;

    @Comment(value = "供应商类型")
    @Column()
    private String suppType;

    @Comment(value = "企业类型")
    @Column()
    private String compType;

    @Comment(value = "企业性质")
    @Column()
    private String compProp;

    @Comment(value = "审批状态")
    @Column()
    private String approveStatus;

    @Comment(value = "认证状态")
    @Column()
    private String authStatus;

    @Comment(value = "认证次数")
    @Column()
    private Integer authTimes;

    @Comment(value = "统一社会信用代码")
    @Column()
    private String certNo;

    @Comment(value = "注册资本")
    @Column()
    private String registerFund;

    @Comment(value = "实缴资本")
    @Column()
    private String paidFund;

    @Comment(value = "公司规模")
    @Column()
    private String compScale;

    @Comment(value = "法定代表人")
    @Column()
    private String reprName;

    @Comment(value = "纳税人类型")
    @Column()
    private String taxpayerType;

    @Comment(value = "经营状态")
    @Column()
    private String oprStatus;

    @Comment(value = "注册地国家")
    @Column()
    private String registerCountry;

    @Comment(value = "注册地省份")
    @Column()
    private String registerProvince;

    @Comment(value = "注册地城市")
    @Column()
    private String registerCity;

    @Comment(value = "注册地址")
    @Column()
    private String registerAddress;

    @Comment(value = "注册电话")
    @Column()
    private String registerTel;

    @Comment(value = "经营范围")
    @Column()
    private String busiScope;

    @Comment(value = "经营地址")
    @Column()
    private String busiAddress;

    @Comment(value = "成立日期")
    @Column()
    private LocalDate setupDate;

    @Comment(value = "注册日期")
    @Column()
    private LocalDate registerDate;

    @Comment(value = "转正日期")
    @Column()
    private LocalDate approveDate;

    @Comment(value = "公司简介")
    @Column()
    private String suppRemark;

    @Comment(value = "官方网站")
    @Column()
    private String webAddress;

    @Comment(value = "引入理由")
    @Column()
    private String enroleDesc;

    @Comment(value = "币种")
    @Column()
    private String currCode;

    @Comment(value = "税区")
    @Column()
    private String taxType;

    @Comment(value = "税码")
    @Column()
    private String taxCode;

    @Comment(value = "税率")
    @Column()
    private Double taxRate;

    @Comment(value = "税率2")
    @Column()
    private Double taxRate2;

    @Comment(value = "税率3")
    @Column()
    private Double taxRate3;

    @Comment(value = "税率")
    @Column()
    private Double taxRate4;

    @Comment(value = "开户银行")
    @Column()
    private String suppBank;

    @Comment(value = "开户支行")
    @Column()
    private String bankBranch;

    @Comment(value = "银行账户")
    @Column()
    private String bankAccount;

    @Comment(value = "付款条款")
    @Column()
    private String paymentTerm;

    @Comment(value = "付款方式")
    @Column()
    private String payMethod;

    @Comment(value = "结算方式")
    @Column()
    private String settleMethod;

    @Comment(value = "发票类型")
    @Column()
    private String invType;

    @Comment(value = "发票类型2")
    @Column()
    private String invType2;

    @Comment(value = "发票类型3")
    @Column()
    private String invType3;

    @Comment(value = "发票类型4")
    @Column()
    private String invType4;

    @Comment(value = "总账类型")
    @Column()
    private String finGlType;

    @Comment(value = "开票抬头")
    @Column()
    private String invTitle;

    @Comment(value = "发票地址")
    @Column()
    private String invAddress;

    @Comment(value = "接口状态")
    @Column()
    private String intfStatus;

    @Comment(value = "接口处理时间")
    @Column()
    private LocalDateTime intfTime;
}
