package com.elitesland.srm.supplier.record.archive.supp.service;

import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.srm.supplier.record.archive.supp.entity.SupplierDO;

import java.util.Optional;

/**
 * @author eric.hao
 * @since 2022/03/16
 */
@Unicom
public interface SupplierService<T> {

    /**
     * 新增或修改 - 主数据
     *
     * @param saveParam 供应商
     * @return 供应商主键ID
     */
    long saveSupp(T saveParam);

    /**
     * 根据suppId查询供应商
     *
     * @param suppId 供应商ID
     * @return 供应商主档信息
     */
    Optional<SupplierDO> findById(long suppId);
}
