package com.elitesland.srm.supplier.record.archive.user.entity;

import com.elitesland.yst.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 供应商用户
 *
 * @author eric.hao
 * @since 2022/11/09
 */
@Entity
@Table(name = "srm_supp_user")
@org.hibernate.annotations.Table(appliesTo = "srm_supp_user", comment = "供应商用户")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SuppUserDO extends BaseModel implements Serializable {

    @Comment(value = "用户ID")
    @Column()
    private Long sysUserId;

    @Comment(value = "用户名")
    @Column()
    private String username;

    @Comment(value = "供应商ID")
    @Column()
    private Long suppId;

    @Comment(value = "供应商编码")
    @Column()
    private String suppCode;

    @Comment(value = "供应商名称")
    @Column()
    private String suppName;

    @Comment("启用标识")
    @Column()
    private Integer enabled;

    @Comment(value = "接口状态")
    @Column()
    private String intfStatus;

    @Comment(value = "接口处理时间")
    @Column()
    private LocalDateTime intfTime;
}
