package com.elitesland.srm.supplier.register.controller;

import com.elitesland.srm.sms.service.SmsService;
import com.elitesland.srm.supplier.register.service.SupplierRegisterService;
import com.elitesland.yst.common.base.ApiResult;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * 供应商登记注册
 *
 * @author eric.hao
 * @since 2022/03/21
 */
@Slf4j
@Api(tags = "供应商登记注册")
@ApiSupport(author = "eric.hao", order = 1)
@RestController
@RequestMapping(value = "/srm/supp", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class SupplierRegisterController {

    private final SupplierRegisterService registerService;
    private final SmsService smsService;

    @ApiOperation(value = "供应商 - 注册")
    @PostMapping(value = "/register")
    @SuppressWarnings("unchecked")
    public ApiResult<Long> registerSupplier(@RequestBody Object saveParam) {
        try {
            long suppId = registerService.registerSupp(saveParam);
            return ApiResult.ok(suppId);
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @ApiOperation(value = "发送验证码")
    @GetMapping(value = "/register/send/{mobile}")
    public ApiResult<?> send(@PathVariable String mobile) {
        try {
            smsService.sendRegisterVerifyCode(mobile);
            return ApiResult.ok();
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
    }
}
