package com.elitesland.srm.util.error;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;

/**
 * @author eric.hao
 * @since 2022/03/21
 */
public class SrmException {

    /**
     * 超出预期的报错
     */
    public static BusinessException unexpected() {
        return new BusinessException("[SRM-ERROR] Unexpected.");
    }

    /**
     * 匿名用户未登录
     */
    public static BusinessException unauthorizedException() {
        return new BusinessException(ApiCode.UNAUTHORIZED, ApiCode.UNAUTHORIZED.getMsg());
    }

    /**
     * 参数异常
     */
    public static BusinessException parameterException(String msg) {
        return new BusinessException(ApiCode.PARAMETER_EXCEPTION, msg);
    }

    /**
     * 业务异常
     */
    public static BusinessException businessException(String msg) {
        return new BusinessException(ApiCode.BUSINESS_EXCEPTION, msg);
    }

    /**
     * 其他异常
     */
    public static BusinessException exception(ApiCode apiCode, String msg) {
        return new BusinessException(apiCode, msg);
    }
}
