/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.srm.iam.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cloudt.authorization.core.SecurityContextUtil;
import com.elitesland.srm.iam.domain.SrmIamExtInfo;
import com.elitesland.srm.iam.domain.SuppUserContext;
import com.elitesland.srm.util.error.SrmException;
import com.elitesland.yst.security.dto.SecurityOrgUserEmpBuDTO;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmIamUtil {
    private static final Logger logger = LoggerFactory.getLogger(SrmIamUtil.class);
    private static final String ERROR_NOT_SUPPLIER = "\u5f53\u524d\u8d26\u53f7\u4e0d\u662f\u4f9b\u5e94\u5546\uff0c\u8bf7\u68c0\u67e5";
    private static final String ERROR_NOT_BIND_EMP = "\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u5458\u5de5\uff0c\u8bf7\u68c0\u67e5";

    public static SrmIamExtInfo currentUserExtInfo() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (ObjectUtil.isNull((Object)user)) {
            throw SrmException.unauthorizedException();
        }
        SrmIamExtInfo extInfo = Optional.ofNullable((SrmIamExtInfo)user.getExtendInfo()).orElse(new SrmIamExtInfo());
        logger.debug("[SRM-IAM] extension info={}", (Object)extInfo);
        return extInfo;
    }

    public static SuppUserContext suppContext() {
        SrmIamExtInfo extInfo = SrmIamUtil.currentUserExtInfo();
        return extInfo.getSuppContext();
    }

    public static boolean isSupplier() {
        return ObjectUtil.isNotNull((Object)SrmIamUtil.suppContext());
    }

    public static boolean isNotSupplier() {
        return ObjectUtil.isNull((Object)SrmIamUtil.suppContext());
    }

    public static Long currentSuppId() {
        SuppUserContext suppContext = SrmIamUtil.suppContext();
        if (ObjectUtil.isNull((Object)suppContext)) {
            throw SrmException.parameterException(ERROR_NOT_SUPPLIER);
        }
        return suppContext.getSuppId();
    }

    public static String currentSuppCode() {
        SuppUserContext suppContext = SrmIamUtil.suppContext();
        if (ObjectUtil.isNull((Object)suppContext)) {
            throw SrmException.parameterException(ERROR_NOT_SUPPLIER);
        }
        return suppContext.getSuppCode();
    }

    public static String currentSuppName() {
        SuppUserContext suppContext = SrmIamUtil.suppContext();
        if (ObjectUtil.isNull((Object)suppContext)) {
            throw SrmException.parameterException(ERROR_NOT_SUPPLIER);
        }
        return suppContext.getSuppName();
    }

    private static SecurityOrgUserEmpBuDTO orgEmpContext() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (ObjectUtil.isNull((Object)user)) {
            throw SrmException.unauthorizedException();
        }
        SecurityOrgUserEmpBuDTO orgEmp = user.getSecurityOrgUserEmpBuDTO();
        if (ObjectUtil.isNull((Object)orgEmp)) {
            throw SrmException.parameterException(ERROR_NOT_BIND_EMP);
        }
        return orgEmp;
    }

    public static Long currentBuId() {
        SecurityOrgUserEmpBuDTO orgEmp = SrmIamUtil.orgEmpContext();
        List buIds = Optional.ofNullable(orgEmp.getEmpBuIds()).orElse(new ArrayList());
        return CollUtil.isNotEmpty((Collection)buIds) ? (Long)buIds.get(0) : 0L;
    }

    public static Long currenEmpId() {
        SecurityOrgUserEmpBuDTO orgEmp = SrmIamUtil.orgEmpContext();
        return orgEmp.getEmpId();
    }
}

